<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMoreFieldsToAdmissionsTable extends Migration
{
    public function up()
    {
        Schema::table('admissions', function (Blueprint $table) {
            $table->string('home_district')->nullable();
            $table->string('village')->nullable();
            $table->string('father_name')->nullable();
            $table->string('father_phone')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('mother_phone')->nullable();
            $table->string('spouse_name')->nullable();
            $table->string('spouse_phone')->nullable();
            $table->string('education_level')->nullable();
        });
    }
    
    public function down()
    {
        Schema::table('admissions', function (Blueprint $table) {
            $table->dropColumn([
                'home_district', 'village', 'father_name', 'father_phone',
                'mother_name', 'mother_phone', 'spouse_name', 'spouse_phone', 'education_level'
            ]);
        });
    }
    
}
