<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Assessment;
use App\Observers\AssessmentObserver;
use App\Models\Admission;
use App\Observers\AdmissionObserver;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
        $this->app->singleton(ActivityLogger::class, function ($app) {
            return new ActivityLogger();
        });
    }

    /**
     * Bootstrap any application services.
     */
public function boot()
{
    Assessment::observe(AssessmentObserver::class);
   Admission::observe(AdmissionObserver::class);
}
}
