<?php
// App/Observers/AdmissionObserver.php
namespace App\Observers;

use App\Models\Admission;
use Illuminate\Support\Facades\Cache;

class AdmissionObserver
{
    public function created(Admission $admission) { $this->clearDashboardCache(); }
    public function updated(Admission $admission) { $this->clearDashboardCache(); }
    public function deleted(Admission $admission) { $this->clearDashboardCache(); }

    private function clearDashboardCache()
    {
        $store = Cache::getStore();
        if ($store instanceof \Illuminate\Cache\TaggableStore) {
            Cache::tags(['dashboard'])->flush();
        } else {
            Cache::forget('dashboard_data_v2');
        }
    }
}