<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Traits\LogsActivity;
use App\Traits\LogsAuth;

class User extends Authenticatable
{
    use HasFactory, Notifiable;
    use LogsActivity, LogsAuth;

    /**
     * Mass assignable attributes
     */
    protected $fillable = [
        // Core user
        'name',
        'full_name',
        'type',
        'email',
        'password',

        // Student fields
        'army_number',
        'rank',
        'unit',
        'phone',
    
        'address',
        'department',
        'date_of_birth',

        // Status & SSO
        'is_active',
        'sso_enabled',
        'last_sso_login',
        'created_via_sso',
        'sso_created_at',

        // MCOP
        'mcop_authenticated',
        'last_mcop_login',
    ];

    /**
     * Hidden attributes
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Attribute casting
     */
    protected function casts(): array
    {
        return [
            'email_verified_at'   => 'datetime',
            'password'            => 'hashed',

            // Student casts
            'date_of_birth'       => 'date',
            'is_active'           => 'boolean',
            'sso_enabled'         => 'boolean',
            'created_via_sso'     => 'boolean',
            'mcop_authenticated'  => 'boolean',
            'last_sso_login'      => 'datetime',
            'last_mcop_login'     => 'datetime',
            'sso_created_at'      => 'datetime',
            'created_at'          => 'datetime',
            'updated_at'          => 'datetime',
        ];
    }

    /**
     * Relationships (copied from Student)
     */


    /**
     * Student logic helpers
     */
    public function hasPassedModule($moduleId): bool
    {
        return $this->examResults()
            ->where('module_id', $moduleId)
            ->where('passed', true)
            ->exists();
    }

    public function getAttemptsCount($moduleId): int
    {
        return $this->examResults()
            ->where('module_id', $moduleId)
            ->count();
    }

    /**
     * MCOP helpers
     */
    public function isMcopAuthenticated(): bool
    {
        return $this->mcop_authenticated === true;
    }

    public function updateMcopLogin(): void
    {
        $this->update([
            'mcop_authenticated' => true,
            'last_mcop_login' => now(),
        ]);
    }
}
