<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
class TwentyTwoCR extends Model
{
    use HasFactory;
    use LogsActivity;
    protected $table = 'twenty_two_c_r_s';
// In TwentyTwoCR.php model
protected $fillable = ['title', 'weight', 'phase'];



    
    public function assessmentDetails()
    {
        return $this->hasMany(CRAssessmentDetail::class, 'twenty_two_c_r_s_id');
    }

    public function assessments()
    {
        return $this->hasManyThrough(
            CRAssessment::class,
            CRAssessmentDetail::class,
            'twenty_two_c_r_s_id',
            'id',
            'id',
            'cr_assessment_id'
        );
    }
}
