<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
class Sec extends Model
{
    use HasFactory;

    use LogsActivity;
    protected $fillable = [
        'name',  // Name of the Section
        'comd_name',   // Name of the Section Commander
        'comd_rank',
        'comd_initials',
        'bn_id',
        'pl_id',
        'coy_id'
    ];

    public function bn(): BelongsTo
    {
        return $this->belongsTo(Bn::class);
    }

    public function coy(): BelongsTo
    {
        return $this->belongsTo(Coy::class);
    }

    public function pl(): BelongsTo
    {
        return $this->belongsTo(Pl::class);
    }
}
