<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
class School extends Model
{

    use LogsActivity;
    protected $fillable = [
        'name', 'army_number', 'rank'
    ];

    // Relationship to assessments
    public function assessments()
    {
        return $this->hasMany(Assessment::class);
    }
    public function courses(): HasMany
    {
        return $this->hasMany(Course::class);
    }
        // A School has many Admissions
        public function admissions()
        {
            return $this->hasMany(Admission::class);
        }
}
