<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
class Pr extends Model
{
    protected $table = 'prs';

    protected $fillable = [
        'army_number',
        'name',
        'rank',
        'marked_by',
        'score',
        'phase',
        'admission_id'
    ];

    public function admission()
    {
        return $this->belongsTo(Admission::class);
    }

    public function rater()
    {
        return $this->belongsTo(Admission::class, 'admission_id');
    }

    protected static function booted()
{
    static::addGlobalScope('activePhase', function ($builder) {
        $phase = \App\Models\Phase::where('is_active', 1)->first();
        if ($phase) {
            $builder->where('phase', $phase->name);
        }
    });
}

}
