<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Pl extends Model
{
    use HasFactory;
    use LogsActivity;
    protected $fillable = [
        'name',  // Name of the Platoon
        'comd_name',
        'coy_id',// Name of the Platoon Commander
        'bn_id',
        'pl_sgt',
        'comd_rank',
        'comd_initials',
        'pl_sgt_rank',
    ];

    public function coy(): BelongsTo
    {
        return $this->belongsTo(Coy::class);
    }

    public function bn(): BelongsTo
    {
        return $this->belongsTo(Bn::class);
    }

    public function secs()
    {
        return $this->hasMany(Sec::class);
    }



}
