<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;

class PhaseConfig extends Model
{
    use LogsActivity;
    protected $fillable = [
        'phase_name',
        'msk_theory_config',
        'msk_practical_config', 
        'character_22cr_config',
        'character_pr_config',
        'passing_criteria',
        'max_scores',
        'is_active'
    ];

    protected $casts = [
        'msk_theory_config' => 'array',
        'msk_practical_config' => 'array',
        'character_22cr_config' => 'array',
        'character_pr_config' => 'array',
        'passing_criteria' => 'array',
        'max_scores' => 'array',
        'is_active' => 'boolean'
    ];
}