<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;

class Intakes extends Model
{
    protected $fillable = ['year','is_active'];


    // An intake belongs to a course
    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function admission()
    {
        return $this->belongsTo(Admission::class);
    }
    // An intake can have many admissions (students enrolled)
    public function admissions()
    {
        return $this->hasMany(Admission::class);
    }
}
