<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
class Intake extends Model
{

    use LogsActivity;
    protected $fillable = ['year', 'description','is_active',];

    public function course()
    {
        return $this->belongsTo(Course::class); // An Intake belongs to a Course
    }

    public function students()
    {
        return $this->hasMany(Student::class); // An Intake has many Students
    }
    
}
