<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GpvReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'report_name',
        'intake_id',
        'school_id',
        'course_id',
        'phase',
        'bn',
        'coy',
        'pl',
        'grade',
        'army_number',
        'total_students',
        'filters',
        'created_by'
    ];

    protected $casts = [
        'filters' => 'array',
    ];

    public function intake()
    {
        return $this->belongsTo(Intakes::class, 'intake_id');
    }

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function details()
    {
        return $this->hasMany(GpvReportDetail::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}