<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
class Course extends Model
{

    use LogsActivity;
    protected $fillable = ['name', 'description', 'school_id'];
  // In Course model
// public function subjects()
// {
//     return $this->hasMany(Subject::class);
// }
public function subjects()
{
    return $this->belongsToMany(Subject::class, 'course_subject');
}

public function courses(): BelongsToMany
{
    return $this->belongsToMany(Course::class);
}

    public function intakes()
    {
        return $this->hasMany(Intake::class); // A Course has many Intakes
    }


    
    public function school()
    {
        return $this->belongsTo(School::class);
    }

//     public function subjects()
// {
//     return $this->belongsToMany(Subject::class, 'course_subject');
// }


}
