<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CRAssessmentDetail extends Model
{
    protected $table = 'cr_assessment_details';

    protected $fillable = [
        'cr_assessment_id',
        'twenty_two_c_r_s_id',
        'rating',
        'individual_cres',
        'frequency','f1','f2','f3','f4','f5'
    ];

    protected $casts = [
        'rating' => 'integer',
        'individual_cres' => 'decimal:2'
    ];

    public function assessment()
    {
        return $this->belongsTo(CRAssessment::class, 'cr_assessment_id');
    }

    public function cr()
    {
        return $this->belongsTo(TwentyTwoCR::class, 'cr_id');
    }

public function twentyTwoCR()
{
    return $this->belongsTo(TwentyTwoCR::class, 'twenty_two_c_r_s_id'); 
}

    // protected static function booted()
    // {
    //     static::saving(function ($detail) {
    //         // Ensure frequency is at least 1
    //         if ($detail->frequency < 1) {
    //             $detail->frequency = 1;
    //         }
    //     });
    // }
}