<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CRAssessment2 extends Model
{
    use HasFactory;

    protected $fillable = [
        'army_number',
        'name',
        'rank',
        'admission_id',
        'phase_id',
        'score',
        'remarks',
        'marked_by'
    ];

    protected $casts = [
        'score' => 'decimal:2',
    ];

    public function admission()
    {
        return $this->belongsTo(Admission::class);
    }

    public function phase()
    {
        return $this->belongsTo(Phase::class);
    }
}