<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
class AssessmentEntry extends Model
{
    use HasFactory;

    protected $fillable = ['assessment_id', 'admission_id', 'subject_id', 'marks', 'comments'];

    public function assessment()
    {
        return $this->belongsTo(Assessment::class);
    }

    public function admission()
    {
        return $this->belongsTo(Admission::class);
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }
}


