<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdmissionPhase extends Model
{
    use HasFactory;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'admission_id',
        'phase',
        'bn',
        'coy',
        'pl',
        'sec'
    ];

    /**
     * Get the admission that owns this phase.
     */
    public function admission()
    {
        return $this->belongsTo(Admission::class);
    }

    /**
     * Scope to get phases for a specific admission
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param int $admissionId
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeForAdmission($query, $admissionId)
    {
        return $query->where('admission_id', $admissionId);
    }

    /**
     * Get the latest phase for an admission
     *
     * @param int $admissionId
     * @return AdmissionPhase|null
     */
    public static function getLatestPhase($admissionId)
    {
        return self::forAdmission($admissionId)
            ->orderBy('phase', 'desc')
            ->first();
    }
}
