<?php



// app/Http/Middleware/CheckSystemReadiness.php
namespace App\Http\Middleware;

use Closure;
use App\Models\Admission;

class CheckSystemReadiness
{
    public function handle($request, Closure $next)
    {
        if (Admission::count() === 0) {
            if ($request->expectsJson()) {
                return response()->json([
                    'error' => 'System not ready',
                    'message' => 'No cadets found. Please add cadets first.',
                    'redirect' => route('admissions.create')
                ], 403);
            }
            
            return redirect()->route('admissions.create')
                ->with('critical_error', 'You must add cadets before using the system.');
        }
        
        return $next($request);
    }
}