<?php

namespace App\Http\Controllers;


use App\Models\Subject;
use App\Models\Course;
use Illuminate\Http\Request;
use App\Models\Phase;

class SubjectController extends Controller
{
    // Constructor to apply middleware for authentication (optional)
    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }

    // Display a listing of the subjects
    public function index()
    {
        // Retrieve all subjects with their related courses
      $subjects = Subject::with('courses')->get();
      
        // Pass subjects to the view
        return view('subjects.index', compact('subjects'));
    }

    // Show the form for creating a new subject
    public function create()
    {
        // Retrieve all courses to display in the course dropdown
        $courses = Course::all();
  $phases = Phase::all();

        // Return the view with course data
        return view('subjects.create', compact('courses', 'phases'));
    }

    // Store a newly created subject in the database
    public function store(Request $request)
    {


    
        // Validate the incoming request
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string',
            'weight'=> 'required',
            'course_id' => 'required|exists:courses,id',
            'phase_id' => 'required|exists:phases,id',
        ]);
    
        // Create a new subject record in the database
        $subject = Subject::create($validated);
    
        // Attach the subject to the course using the course_id from the request
        $course = Course::findOrFail($validated['course_id']);
        $course->subjects()->attach($subject->id);
    
        // Redirect back to subjects list with success message
        return redirect()->route('subjects.index')
            ->with('success', 'Subject created and attached to course successfully!');
    }
    

    // Show the form for editing the specified subject
    public function edit(Subject $subject)
    {
        // Retrieve all courses to display in the course dropdown
        $courses = Course::all();
  $phases = Phase::all();

        // Return the view with course and subject data
        return view('subjects.edit', compact('subject', 'courses', 'phases'));
    }

    // Update the specified subject in the database
    public function update(Request $request, Subject $subject)
    {
        // Validate the incoming request
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'weight'=> 'required',
            'code'=> 'required',
            'course_id' => 'required|exists:courses,id',
            'phase_id' => 'required|exists:phases,id',
        ]);

        // Update the subject record
        $subject->update($validated);

        // Redirect back to subjects list with success message
        return redirect()->route('subjects.index')
            ->with('success', 'Subject updated successfully!');
    }

    // Remove the specified subject from the database
    public function destroy(Subject $subject)
    {
        $subject->delete();
        
        return redirect()->route('subjects.index')
            ->with('success', 'Subject deleted successfully!');
    }
    
    public function getSubjects(Request $request)
    {
        $request->validate([
            'course_id' => 'required|exists:courses,id',
        ]);
    
        // Retrieve the course and its related subjects via the pivot table
        $course = Course::find($request->course_id);
    
        // Get all related subjects for this course
        $subjects = $course->subjects;
    
        return response()->json($subjects);
    }
    
    




}
