<?php

namespace App\Http\Controllers;

use App\Models\Bn;
use App\Models\Coy;
use App\Models\Pl;
use App\Models\Sec;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SecController extends Controller
{
    public function index()
    {
        try {
            $sec = Sec::all();
        } catch (\Exception $e) {
            Log::error('Error fetching sections: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to fetch sections.');
        }
        return view('bn.index', compact('sec'));
    }

    public function create()
    {
        try {
            $pls = Pl::all();
            $coys = Coy::all();
            $bns = Bn::all();

            
        } catch (\Exception $e) {
            Log::error('Error fetching platoons: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to fetch platoons.');
        }
        return view('sec.create', compact('pls','bns', 'coys'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'coy_id' => 'required|exists:coys,id',
            'bn_id' => 'required|exists:bns,id',
            'pl_id' => 'required|exists:pls,id',
            'comd_name' => 'nullable|string|max:255',
            'comd_rank' => 'nullable|string|max:255',
            'comd_initials' => 'nullable|string|max:255',
        ]);

        DB::beginTransaction();
        try {
            Sec::create($validated);
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Section created successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error creating section: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to create section.');
        }
    }

    public function edit(Sec $sec)
    {
        try {
            $pls = Pl::all();
            $coys = Coy::all();
            $bns = Bn::all();
        } catch (\Exception $e) {
            Log::error('Error fetching platoons: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to fetch platoons.');
        }
        return view('sec.edit', compact('sec', 'pls','bns', 'coys'));
    }

    public function update(Request $request, Sec $sec)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'coy_id' => 'required|exists:coys,id',
            'bn_id' => 'required|exists:bns,id',
            'pl_id' => 'required|exists:pls,id',
            'comd_name' => 'nullable|string|max:255',
            'comd_rank' => 'nullable|string|max:255',
            'comd_initials' => 'nullable|string|max:255'
        ]);

        DB::beginTransaction();
        try {
            $sec->update($validated);
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Section updated successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error updating section: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to update section.');
        }
    }

    public function destroy(Sec $sec)
    {
        DB::beginTransaction();
        try {
            $sec->delete();
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Section deleted successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error deleting section: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to delete section.');
        }
    }

    public function getPlsByCoy(Request $request)
{
    try {
        // Get the Platoons based on the selected Coy
        $pls = Pl::where('coy_id', $request->coy_id)->get(['id', 'name']);
        return response()->json($pls);
    } catch (\Exception $e) {
        Log::error('Error fetching platoons: ' . $e->getMessage());
        return response()->json(['error' => 'Failed to fetch platoons.'], 500);
    }
}

public function getCoysByBn(Request $request)
{
    try {
        // Get the Coys based on the selected Bn
        $coys = Coy::where('bn_id', $request->bn_id)->get(['id', 'name']);
        return response()->json($coys);
    } catch (\Exception $e) {
        Log::error('Error fetching companies: ' . $e->getMessage());
        return response()->json(['error' => 'Failed to fetch coys.'], 500);
    }
}





}
