<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Report; // Ensure you import the Report model

class ReportController extends Controller
{
    public function verify($token)
    {
        $report = Report::where('token', $token)->first();
    
        if (!$report) {
            return view('reports.invalid');
        }
    
        // Check if report is revoked or expired
        if ($report->revoked) {
            return view('reports.invalid', ['message' => 'This report has been revoked.']);
        }
    
        if ($report->expires_at && now()->greaterThan($report->expires_at)) {
            return view('reports.invalid', ['message' => 'This report has expired.']);
        }
    
        return view('reports.verified', ['report' => $report]);
    }
}
