<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Jimmyjs\ReportGenerator\Facades\PdfReport;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Assessment;
use App\Imports\AssessmentImport;
class AssessmentController extends Controller
{


    public function generateAssessmentReport(Request $request)
{
    // Get data from the assessments table
    $assessments = Assessment::all(); // Adjust the query as needed

    // Set the report title
    $title = "Assessments Report";

    // Set report meta (filters, dates, etc.)
    $meta = [
        'Generated On' => now()->toDateString(),
        // Add any additional filter details if needed
    ];

    // Define the columns to display in the report
    $columns = [
        'ID' => 'id',
        'Weekly' => 'weekly',
        'Course Name' => 'course_name',
        'Student Name' => 'student_name',
        'Phase' => 'phase',
        'Week' => 'week',
        'Created At' => 'created_at', // This will match the column name in your database
    ];

    // Generate PDF report
    return PdfReport::of($title, $meta, $assessments, $columns)
                    ->editColumn('Created At', [
                        'displayAs' => function($result) {
                            return $result->created_at->format('d M Y');
                        }
                    ])
                    ->showTotal([ // Summing up a column
                        'Grade' => 'point' // Assuming 'grade' is numeric
                    ])
                    ->stream(); // This streams the PDF directly
}

  
    public function showForm()
    {
        return view('importForm'); // Show the import form
    }

    // Handle the file import
    public function import(Request $request)
    {
        // Validate the uploaded file
        $request->validate([
            'file' => 'required|mimes:xlsx,xls',
        ]);

        // Import the data
        try {
            Excel::import(new AssessmentImport, $request->file('file'));
            return back()->with('success', 'Marks imported successfully!');
        } catch (\Exception $e) {
            return back()->with('error', 'There was an error importing the file.');
        }
    }


}
