<?php

namespace App\Imports;

use App\Models\Admission;
use App\Models\Student;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow; // Add this

class AdmissionsImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {


        // Check if 'army_number' exists to avoid the undefined array key error
        if (!isset($row['army_number'])) {
            throw new \Exception("Missing 'army_number' field in the imported data.");
        }

        // Create or get the student based on army_number
        $student = Student::firstOrCreate(
            ['army_number' => $row['army_number']],
            [
                'name' => $row['name'] ?? 'Unknown',
                'rank' => $row['rank'] ?? 'Unknown',
            ]
        );

        // Return new admission and associate it with the student
        return new Admission([
            'rank'           => $row['rank'] ?? 'Unknown',
            'MIL_ID_No'      => $row['MIL_ID_No'] ?? null,
            'school_id'      => $row['school_id'] ?? null,
            'course_id'      => $row['course_id'] ?? null,
            'intake_id'      => $row['intake_id'] ?? null,
            'name'           => $row['name'] ?? 'Unknown',
            'army_number'    => $row['army_number'],
            'bn'        => $row['bn'] ?? null,
            'coy'            => $row['coy'] ?? null,
            'pl'             => $row['pl'] ?? null,
            'sec'            => $row['sec'] ?? null,
            'student_id'     => $student->id,  // Associate the student with the admission
        ]);
    }
}
