<?php

namespace App\Exports;

use App\Models\Admission;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class AdmissionsExport implements FromCollection, WithHeadings
{
    public function collection()
    {
        return Admission::with(['school', 'course'])->get()->map(function($admission) {
            return [
                'Army Number' => $admission->army_number,
                'Rank' => $admission->rank,
                'Name' => $admission->name,
                'Course' => $admission->course->name,
                'Bn' => $admission->bn,
                'Coy' => $admission->coy
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Army Number',
            'Rank',
            'Name',
            'Course',
            'Bn',
            'Coy'
        ];
    }
}